//+------------------------------------------------------------------+
//|                                      Movable Dashboards MQL5.mq5 |
//|                                                      Sahil Bagdi |
//|                         https://www.mql5.com/en/users/sahilbagdi |
//+------------------------------------------------------------------+

#include "GUI_Movable.mqh"
GUI_Movable Dashboard;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   //---
   //Set the name of the rectangle as "TestRectangle"
   string name = "TestRectangle";
   //Create a Rectangle Label Object at (time1, price1)=(0,0)
   ObjectCreate(0, name, OBJ_RECTANGLE_LABEL, 0, 0, 0);
   //Set XDistance to 100px i.e. Distance of Rectangle Label 100px from Left of the Chart Window
   ObjectSetInteger(0, name, OBJPROP_XDISTANCE, 100);
   //Set YDistance to 100px i.e. Distance of Rectangle Label 100px from Top of the Chart Window
   ObjectSetInteger(0, name, OBJPROP_YDISTANCE, 100);
   //Set XSize to 200px i.e. Width of Rectangle Label
   ObjectSetInteger(0, name, OBJPROP_XSIZE, 200);
   //Set YSize to 200px i.e. Height of Rectangle Label
   ObjectSetInteger(0, name, OBJPROP_YSIZE, 200);
   //Set CHART_EVENT_MOUSE_MOVE to true to detect mouse move event
   ChartSetInteger(0, CHART_EVENT_MOUSE_MOVE, true);
   //Give dashboard's name to the class instance
   Dashboard.Name = name;
   
//---
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long& lparam, const double& dparam, const string& sparam)
  {
   Dashboard.OnEvent(id, lparam, dparam, sparam);
  }
//+------------------------------------------------------------------+